package gov.va.med.mhv.usermgmt.web.converter;

import java.io.Serializable;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.EmergencyContactDTO;
import gov.va.med.mhv.usermgmt.web.formbean.EmergencyContact;

@Component
public class EmergencyContactDTOConverter implements Converter<EmergencyContact, EmergencyContactDTO>, Serializable {
	private static final long serialVersionUID = 1L;

	@Override
	public EmergencyContactDTO convert(EmergencyContact ec) {
		EmergencyContactDTO dto = new EmergencyContactDTO();
		
		dto.setId(ec.getEmergencyContactId());
		dto.setAddressCity(ec.getCity());
		dto.setContactInfoContactMethod(ec.getContactMethod());
		dto.setAddressCountry(ec.getCountry());
		dto.setContactInfoEmail(ec.getEmail());
		dto.setContactInfoFax(ec.getFax());
		dto.setFirstName(ec.getFirstName());
		dto.setContactInfoHomePhone(ec.getHomePhone());
		dto.setLastName(ec.getLastName());
		dto.setMiddleName(ec.getMiddleName());
		dto.setContactInfoMobilePhone(ec.getMobilePhone());
		dto.setContactInfoPager(ec.getPager());
		dto.setAddressPostalCode(ec.getPostalCode());
		dto.setIsPrimary(ec.getPrimary());
		dto.setPriority(ec.getPriority());
		dto.setAddressProvince(ec.getProvince());
		dto.setRelationship(ec.getRelationShip());
		dto.setAddressState(ec.getState());
		dto.setAddressStreet1(ec.getStreet1());
		dto.setAddressStreet2(ec.getStreet2());
		dto.setTitle(ec.getTitle());
		
		dto.setSuffix(ec.getSuffix());
		
		dto.setContactInfoWorkPhone(ec.getWorkPhone());
		dto.setContactInfoWorkPhoneExt(ec.getWorkPhoneExt());
		dto.setUserProfileId(ec.getUserProfileId());
		
		return dto;
	}

}